function new_gossip_heard = spread_gossip(network_input,old_gossip_heard)
%take in a network structure and a vector that says who has heard the
%gossip. Return an updated vector in which all those adjacent to someone
%who has heard the gossip have now heard it. 

    new_gossip_heard=old_gossip_heard; %initialize; all people who have previousy heard the gossip will still have heard it after this step.

    for i=1:length(old_gossip_heard)
        %identify those who have previously heard the gossip
        if(old_gossip_heard(i)>0)
            for j=1:length(old_gossip_heard)
                %Anyone adjacent to them will have heard the gossip after this step. 
                if(network_input(i,j)>0)
                    new_gossip_heard(j)=1;
                end
            end
        end
    end

end